<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>Email Verification</title>

    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap"
      rel="stylesheet"
    />
  </head>
  <body
    style="
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #ffffff;
      font-size: 14px;
    "
  >
    <div
      style="
        max-width: 680px;
        margin: 0 auto;
        padding: 45px 30px 60px;
        background: #2e2940;
        background-image: none;
        background-repeat: no-repeat;
        background-size: 800px 452px;
        background-position: top center;
        font-size: 14px;
        color: #ffffff; /* Updated text color for better contrast */
      "
    >
      <header>
        <table style="width: 100%;">
          <tbody>
            <tr style="height: 0;">
              <td>
                <!-- Larger Logo -->
                <img
                  alt="The Coaching App Logo"
                  src="{{ asset('storage/images/Logo.png') }}"
                  style="height: 50px; width: auto;" 
                />
              </td>
              <td style="text-align: right;">
                <span
                  style="font-size: 16px; line-height: 30px; color: #ffffff;"
                >
                  {{ now()->format('d M, Y') }}
                </span>
              </td>
            </tr>
          </tbody>
        </table>
      </header>

      <main>
        <div
          style="
            margin: 0;
            margin-top: 70px;
            padding: 92px 30px 115px;
            background: #ffffff;
            border-radius: 30px;
            text-align: center;
          "
        >
          <div style="width: 100%; max-width: 489px; margin: 0 auto;">
            <h1
              style="
                margin: 0;
                font-size: 24px;
                font-weight: 500;
                color: #1f1f1f; /* Keep this dark for contrast on white background */
              "
            >
              Your Verification Code
            </h1>
            <p
              style="
                margin: 0;
                margin-top: 17px;
                font-size: 16px;
                font-weight: 500;
                color: #1f1f1f; /* Keep this dark for contrast on white background */
              "
            >
              <!-- Hey {{ $email }}, -->
              Hey,
            </p>
            <p
              style="
                margin: 0;
                margin-top: 17px;
                font-weight: 500;
                letter-spacing: 0.56px;
                color: #1f1f1f; /* Keep this dark for contrast on white background */
              "
            >
              Thank you for choosing The Coaching App. Use the following verification code to complete the email verification process. This code is valid for
              <span style="font-weight: 600; color: #1f1f1f;">10 minutes</span>.
              Do not share this code with others.
            </p>
            <p
              style="
                margin: 0;
                margin-top: 60px;
                font-size: 40px;
                font-weight: 600;
                letter-spacing: 25px;
                color: #ba3d4f; /* Keep this color for emphasis */
              "
            >
              {{ $verificationCode }}
            </p>
          </div>
        </div>

        <p
          style="
            max-width: 400px;
            margin: 0 auto;
            margin-top: 90px;
            text-align: center;
            font-weight: 500;
            color: #e0e0e0; /* Updated text color for better contrast */
          "
        >
          Need help? Ask at
          <a
            href="mailto:support@thecoachingapp.fit"
            style="color: #499fb6; text-decoration: none;"
          >
            support@thecoachingapp.fit
          </a>
          or visit our
          <a
            href="https://www.thecoachingapp.fit/help"
            target="_blank"
            style="color: #499fb6; text-decoration: none;"
          >
            Help Center
          </a>
        </p>
      </main>

      <footer
        style="
          width: 100%;
          max-width: 490px;
          margin: 20px auto 0;
          text-align: center;
          border-top: 1px solid #e6ebf1;
        "
      >
        <p
          style="
            margin: 0;
            margin-top: 40px;
            font-size: 16px;
            font-weight: 600;
            color: #ffffff; /* Updated text color for better contrast */
          "
        >
          The Coaching App
        </p>
        <p style="margin: 0; margin-top: 8px; color: #e0e0e0;"> <!-- Updated text color -->
          123 Coaching Street, City, State.
        </p>
        <div style="margin: 0; margin-top: 16px;">
          <a
            href="https://facebook.com/thecoachingapp"
            target="_blank"
            style="display: inline-block;"
          >
            <img
              width="36px"
              alt="Facebook"
              src="https://archisketch-resources.s3.ap-northeast-2.amazonaws.com/vrstyler/1661502815169_682499/email-template-icon-facebook"
            />
          </a>
          <a
            href="https://instagram.com/thecoachingapp"
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Instagram"
              src="https://archisketch-resources.s3.ap-northeast-2.amazonaws.com/vrstyler/1661504218208_684135/email-template-icon-instagram"
            />
          </a>
          <a
            href="https://twitter.com/thecoachingapp"
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Twitter"
              src="https://archisketch-resources.s3.ap-northeast-2.amazonaws.com/vrstyler/1661503043040_372004/email-template-icon-twitter"
            />
          </a>
          <a
            href="https://youtube.com/thecoachingapp"
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Youtube"
              src="https://archisketch-resources.s3.ap-northeast-2.amazonaws.com/vrstyler/1661503195931_210869/email-template-icon-youtube"
            />
          </a>
        </div>
        <p style="margin: 0; margin-top: 16px; color: #e0e0e0;"> <!-- Updated text color -->
          Copyright © {{ now()->year }} The Coaching App. All rights reserved.
        </p>
      </footer>
    </div>
  </body>
</html>