<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientVerificationCodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_verification_codes', function (Blueprint $table) {
            $table->bigIncrements('code_id');
            $table->string('email');
            $table->string('code_for_email_verification')->nullable(); // Email verification code
            $table->timestamp('code_for_email_verification_expires_at')->nullable(); // Expiration time for email verification code
            $table->string('code_for_forgot_password_verification')->nullable(); // Password reset code
            $table->timestamp('code_for_forgot_password_verification_expires_at')->nullable(); // Expiration time for password reset code

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));  

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_verification_codes');
    }
}
