<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRecentCoachesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recent_coaches', function (Blueprint $table) {
            $table->id('recent_coach_id'); // Primary Key
            $table->unsignedBigInteger('client_id'); // Foreign Key for clients
            $table->unsignedBigInteger('coach_id'); // Foreign Key for coaches

           // Foreign key constraints
            $table->foreign('client_id')->references('client_id')->on('clients');
            $table->foreign('coach_id')->references('coach_id')->on('coaches');

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recent_coaches');
    }
}
