<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFavoriteCoachesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('favorite_coaches', function (Blueprint $table) {
            $table->id('favorite_id'); // Auto-incrementing primary key
            $table->unsignedBigInteger('client_id')->nullable(); 
            $table->unsignedBigInteger('coach_id')->nullable(); 

            // Foreign key constraints
            $table->foreign('client_id')->references('client_id')->on('clients');
            $table->foreign('coach_id')->references('coach_id')->on('coaches');

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('favorite_coaches');
    }
}
