<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMealItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meal_items', function (Blueprint $table) {
            $table->id('meal_items_id');
            $table->unsignedBigInteger('meal_id');
            $table->string('item_title');
            $table->float('serving_size');
            $table->string('serving_unit');
            $table->float('fat');
            $table->float('carbohydrates');
            $table->float('protein');
            $table->float('fibre');
            $table->float('calories');
            $table->float('sugar');
            $table->float('sodium');
            $table->text('note')->nullable();

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));

            // Foreign key constraint
            $table->foreign('meal_id')->references('meal_id')->on('meals');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meal_items');
    }
}
