<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExercisesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('exercises', function (Blueprint $table) {
            $table->id('exercise_id');
            $table->unsignedBigInteger('workout_day_id');
            $table->string('exercise_name');
            $table->string('sets');
            $table->string('workout_video')->nullable();
            $table->text('note')->nullable();

            // $table->unique(['workout_day_id', 'exercise_name']);

            $table->foreign('workout_day_id')->references('workout_day_id')->on('workout_days');

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('exercises');
    }
}

