<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->bigIncrements('invoice_id');
            $table->string('stripe_invoice_id')->unique();
            $table->string('customer')->nullable();; // Foreign key to coaches.stripe_id
            $table->foreign('customer')->references('stripe_id')->on('coaches');
            $table->unsignedBigInteger('coach_id')->nullable();; // Foreign key to coaches.coach_id
            $table->foreign('coach_id')->references('coach_id')->on('coaches');
            $table->float('amount_paid')->nullable(); // Adjust precision as needed
            $table->string('status')->nullable();
            $table->string('client_secret')->nullable();
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
