<?php

namespace App\Observers;

use App\Models\Clients;
use App\Models\RecentCoaches;

class ClientObserver
{
    /**
     * Handle the clients "created" event.
     *
     * @param  \App\Models\Clients  $clients
     * @return void
     */
    // Triggered when a new client is created
    public function created(Clients $clients)
    {
        if ($clients->coach_id) {
            // Add the initial coach to the recent_coaches table
            RecentCoaches::updateOrCreate(
                ['client_id' => $clients->client_id, 'coach_id' => $clients->coach_id]
            );
        }
    }

    /**
     * Handle the clients "updated" event.
     *
     * @param  \App\Models\Clients  $client
     * @return void
     */
    // Triggered when a client is updated
    public function updated(Clients $client)
    {
        // Check if coach_id has changed
        if ($client->isDirty('coach_id') && $client->coach_id) {
            $newCoachId = $client->coach_id;

            // Add the new coach to the recent_coaches table
            RecentCoaches::updateOrCreate(
                ['client_id' => $client->client_id, 'coach_id' => $newCoachId]
            );
        }
    }

    /**
     * Handle the clients "deleted" event.
     *
     * @param  \App\Models\Clients  $clients
     * @return void
     */
    public function deleted(Clients $clients)
    {
        //
    }

    /**
     * Handle the clients "restored" event.
     *
     * @param  \App\Models\Clients  $clients
     * @return void
     */
    public function restored(Clients $clients)
    {
        //
    }

    /**
     * Handle the clients "force deleted" event.
     *
     * @param  \App\Models\Clients  $clients
     * @return void
     */
    public function forceDeleted(Clients $clients)
    {
        //
    }
}
