<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class exercises extends Model
{
    protected $primaryKey = 'exercise_id';

    protected $fillable = ['workout_day_id', 'exercise_name', 'sets', 'workout_video', 'note'];

    // Define relationships
    public function repsSets()
    {
        return $this->hasMany(repsSets::class, 'exercise_id', 'exercise_id');
    }


    public function workoutDay()
    {
        return $this->belongsTo(workoutDays::class, 'workout_day_id', 'workout_day_id');
    }

}
