<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notifications extends Model
{
    // The primary key associated with the table
    protected $primaryKey = 'notification_id';

    // Specify the attributes that are mass assignable
    protected $fillable = [
        'recipient_user_id',
        'sender_user_id',
        'notification_type_id',
        'related_entity_type',
        'related_entity_id',
        'is_read'
    ];


   // Relationships

    // Notification belongs to a NotificationType
    public function notificationType()
    {
        return $this->belongsTo(NotificationType::class, 'notification_type_id');
    }

    // Notification belongs to a Client (recipient)
    public function recipient()
    {
        return $this->belongsTo(Client::class, 'recipient_user_id', 'client_id');
    }

    // Notification belongs to a Coach (sender)
    public function sender()
    {
        return $this->belongsTo(Coach::class, 'sender_user_id', 'coach_id');
    }

    // Additional method to mark notification as read
    public function markAsRead()
    {
        $this->is_read = true;
        $this->save();
    }
}
