<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientPreferencesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_preferences', function (Blueprint $table) {
            $table->id('client_preferences_id'); // Primary key

            // Foreign keys
            $table->unsignedBigInteger('client_id'); // Client ID (foreign key)
            $table->unsignedBigInteger('coach_id');  // Coach ID (foreign key)

            // Status fields
            $table->enum('coach_status', ['accept', 'reject'])->nullable(); // Coach's response (optional)
            $table->enum('client_status', ['accept', 'reject'])->nullable(); // Client's response (optional)

            // Message field
            $table->enum('message', [
                'looking for a coach',
                'rejected by coach',
                'accepted by coach',
                'rejected by client',
                'accepted by client',
                'selected other coach'
            ]);

            // Foreign key constraints
            $table->foreign('client_id')->references('client_id')->on('clients');
            $table->foreign('coach_id')->references('coach_id')->on('coaches');

            // Unique constraint if necessary
            // $table->unique(['client_id', 'coach_id']); // Ensure that a client can only prefer a coach once

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_preferences');
    }
}
