<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMacroPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('macro_plans', function (Blueprint $table) {
            $table->id('macro_plan_id');
            $table->unsignedBigInteger('coach_id');
            $table->unsignedBigInteger('client_assigned_id');
            $table->string('title');
            $table->string('protein');
            $table->string('carbs');
            $table->string('fats');
            $table->string('type');
            $table->text('note')->nullable();

            // Enforce unique combination of coach_id and client_assigned_id
            // $table->unique(['coach_id', 'client_assigned_id']);
            
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));

            // Foreign key constraints
            $table->foreign('coach_id')->references('coach_id')->on('coaches');
            $table->foreign('client_assigned_id')->references('client_id')->on('clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('macro_plans');
    }
}



