<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCheckInPicturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('check_in_pictures', function (Blueprint $table) {
            $table->bigIncrements('picture_id'); // Primary key

            $table->string('picture'); // Required
            $table->unsignedBigInteger('check_in_details_id'); // Foreign key to check_in_details table

            // Foreign key
            $table->foreign('check_in_details_id')->references('details_id')->on('check_in_details');

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('check_in_pictures');
    }
}
