<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCheckInDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('check_in_details', function (Blueprint $table) {
            $table->bigIncrements('details_id'); // Primary key

            $table->unsignedBigInteger('client_id'); // Foreign key to client_id table
            $table->unsignedBigInteger('coach_id'); // Foreign key to coaches table

            // Required fields
            $table->date('checkin_date');
            $table->string('checkin_day');
            $table->string('checkin_week');
            $table->string('checkin_month');
            $table->string('checkin_year');
            $table->time('checkin_time');

            // Optional fields
            $table->string('chest')->nullable(); // Adjust precision as needed
            $table->string('shoulders')->nullable();
            $table->string('waist')->nullable();
            $table->string('hips')->nullable();
            $table->string('thighs')->nullable();
            $table->string('arms')->nullable();
            $table->text('how_was_your_week')->nullable();
            $table->text('any_stress_depression')->nullable();
            $table->text('how_was_macros')->nullable();
            $table->string('how_many_missed_meals')->nullable();
            $table->string('how_many_cheat_meals')->nullable();
            $table->text('how_was_sleep')->nullable();
            $table->text('how_is_appetite_and_digestion')->nullable();
            $table->text('how_is_recovery')->nullable();
            $table->text('training_strength')->nullable();
            $table->text('coach_feedback')->nullable(); // Optional

            // Foreign keys
            $table->foreign('client_id')->references('client_id')->on('clients');
            $table->foreign('coach_id')->references('coach_id')->on('coaches');

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));  
        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('check_in_details');
    }
}
