<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->bigIncrements('client_id');
            $table->unsignedBigInteger('coach_id')->nullable(); 
            $table->foreign('coach_id')->references('coach_id')->on('coaches');
            $table->string('full_name');
            $table->string('email')->unique();
            $table->string('password')->nullable();

            $table->string('username')->unique();
            $table->string('profile_picture')->nullable();
            $table->boolean('is_email_verified')->default(false);

            $table->text('gender')->nullable();
            $table->text('age')->nullable();
            $table->text('level')->nullable();
            $table->text('weight')->nullable();
            $table->text('height')->nullable();

            $table->boolean('is_diet_assigned')->default(false);
            $table->boolean('is_macro_assigned')->default(false);
            $table->boolean('is_training_assigned')->default(false);

            $table->string('code_for_email_verification')->nullable();
            $table->timestamp('code_for_email_verification_expires_at')->nullable();
            $table->string('code_for_forgot_password_verification')->nullable();
            $table->timestamp('code_for_forgot_password_verification_expires_at')->nullable();
            
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));  

        });
    }



    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients');
    }
}
