<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoachesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coaches', function (Blueprint $table) {
            $table->bigIncrements('coach_id');
            $table->string('username')->unique();
            $table->string('full_name');
            $table->string('phone');
            $table->string('email')->unique();
            $table->string('password');
            $table->text('bio')->nullable();
            $table->text('city')->nullable();
            $table->text('postal_code')->nullable();
            $table->text('country')->nullable();
            $table->string('intro')->nullable();
            $table->string('profile_picture')->nullable();
            $table->string('stripe_id')->nullable()->unique();
            $table->enum('user_role',['admin','coach'])->default('coach');
            $table->boolean('is_email_verified')->default(false);
            $table->string('code_for_email_verification')->nullable();
            $table->timestamp('code_for_email_verification_expires_at')->nullable();
            $table->string('code_for_forgot_password_verification')->nullable();
            $table->timestamp('code_for_forgot_password_verification_expires_at')->nullable();            
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coaches');
    }
}
