<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NotificationTypes extends Model
{

    // The primary key associated with the table
    protected $primaryKey = 'notification_type_id';

    // Specify the attributes that are mass assignable
    protected $fillable = [
        'name',
        'description'
    ];

    // Relationships: A notification type can have many notifications
    public function notifications()
    {
        return $this->hasMany(Notification::class, 'notification_type_id');
    }
}

