<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Meals extends Model
{
    protected $primaryKey = 'meal_id';

    protected $fillable = [
        'diet_day_id',
        'meal_title',
    ];

    public function mealItems()
    {
        return $this->hasMany(MealItems::class, 'meal_id', 'meal_id');
    }

    public function meals() {
        return $this->hasMany(Meals::class, 'diet_day_id');
    }


}
