<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
// use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Mail;

use App\Mail\VerifyEmail;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Mail\ResetPassword;



class ApiAuthController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function signup (Request $request) {

        // Check whether date_of_birth field is null, then delete that field before going to validation.
        // Validate errors one by one, instead of all
        // Email verification api, to update is_verified field
        if($request['date_of_birth']=="\"\""){
            $request->request->remove('date_of_birth');
        }

        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|string|max:255|unique:users',
            'password' => 'required|string|confirmed',
            'date_of_birth' => 'date',
        ]);
        if ($validator->fails())
        {
            // return response(['errors'=>$validator->errors()->first()], 200);
            // $firt_error = implode(" ", $validator->errors()->first());
            return response(['status' => 0, 'message'=>$validator->errors()->first()], 200);
        }

        $request['password']=Hash::make($request['password']);
        $request['remember_token'] = Str::random(10);

        $user = User::create($request->toArray());
        if ($user) {
            $verify2 =  DB::table('password_resets')->where([
                ['email', $request->all()['email']]
            ]);

            if ($verify2->exists()) {
                $verify2->delete();
            }
            $pin = rand(100000, 999999);
            DB::table('password_resets')->insert( ['email' => $request->all()['email'],'token' => $pin]);
        }
        
        // after signing up, we will send the verification to the email address
        Mail::to($request->email)->send(new VerifyEmail($pin));
      

        $token = $user->createToken('Laravel Password Grant Client')->accessToken;
        $response = ['status' => 1, 'message' => "Registered successfully. Please check your email for a 6-digit pin to verify your email."];
        

        return response($response, 200);

    }



    /**
     * @param Request $request
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    // if the status of this request is 0 with message email not verified, we will call the resendPin api with given email to resend the pin code  
    public function signin (Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|max:255|exists:users,email',
            'password' => 'required|string|max:255',
        ]);
        if ($validator->fails())
        {
            return response(['status' => 0, 'message'=>$validator->errors()->first()], 200);
        }


        $user = User::where('email', $request->email)->first();
        if (Hash::check($request->password, $user->password)) {
            if (!$user->is_verified){
                return response(['status' => 0, 'message'=>'email not verified'], 200);

            }
            $token = $user->createToken('Laravel Password Grant Client')->accessToken;
            $user['token'] = $token;
            $response = ['status' => 1, 'message' => 'User logged in', 'data'=> $user];
            return response($response, 200);

        } else {
            $response = ['status' => 0, "message" => "Password is wrong"];
            return response($response, 200);
        }

    }
    public function changePassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id'=> 'required|integer|exists:users,user_id',
            'old_password' => 'required|string|max:255',
            'new_password' => 'required|string|max:255',
        ]);
        if ($validator->fails())
        {
            return response(['status' => 0, 'message'=>$validator->errors()->first()], 200);
        }

        $user = User::where('user_id', $request->user_id)->first();
        if ($user) {
            if ((Hash::check(request('old_password'), $user->password)) == false) {
                $response = ["status" => 0, "message" => "Old password is not correct."];
                return response($response, 200);

            } else {
                User::where('user_id', $request->user_id)->update(['password' => Hash::make($request->new_password)]);
                $response = ["status" => 1, "message" => "Password changed successfully."];
                return response($response, 200);
            }
        }
        else {
            $response = ["status" => 0, "message" =>'Unexpected error'];
            return response($response, 200);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function signout (Request $request) {
        $token = $request->user()->token();
        $token->revoke();
        $response = ['status' => 1, 'message' => 'You have been successfully logged out!'];
        return response($response, 200);
    }

    public function sendPin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'=> 'required|string|max:255|exists:users,email',
        ]);

        if ($validator->fails()) {
            return response(['status' => 0, 'message' => $validator->errors()->first()], 200);
        }

        $verify =  DB::table('password_resets')->where([['email', $request->all()['email']]]);

        if ($verify->exists()) {
            $verify->delete();
        }

        $token = random_int(100000, 999999);
        $password_reset = DB::table('password_resets')->insert(['email' => $request->all()['email'],'token' =>  $token,
            'created_at' => Carbon::now()
        ]);

        if ($password_reset) {
            Mail::to($request->all()['email'])->send(new VerifyEmail($token));
            return response(['status' => 1, 'message' => "Please check your email for a 6 digit pin"], 200);
        }
    }

    // If the above buttons response status is 1 then we call the following api, by passing the value of email and pin sent to the email:
    public function verifyPin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'=> 'required|string|max:255|exists:users,email',
            'pin' => 'required',
            'cat'=> 'required|string|in:email,password',

        ]);

        if ($validator->fails()) {
            return response(['status' => 0, 'message' => $validator->errors()->first()], 200);
        }

        $check = DB::table('password_resets')->where('email', $request->email)->where('token', $request->pin);
        if ($check->get()->isEmpty()) {
            return response(['status' => 0, 'message' => "Invalid PIN"], 200);

        }
        if ($check->exists()) {
            $difference = Carbon::now()->diffInSeconds($check->first()->created_at);
            if ($difference > 3600) {
                return response(['status' => 0, 'message' => "Pin Expired"], 200);
            }
            


            if ($request->cat=="email") {
                $delete = DB::table('password_resets')->where('email', $request->email)->where('token', $request->pin)->delete();
                $user = User::where('email',$request->email);
                $user->update(['is_verified'=>1]);

                $user = User::where('email', $request->email)->first();
                $token = $user->createToken('Laravel Password Grant Client')->accessToken;
                $user['token'] = $token;
                $response = ['status' => 1, 'message' => 'Your email has been verified', 'data'=> $user];
                return response($response, 200);
            }
            if ($request->cat=="password"){
                $delete = DB::table('password_resets')->where('email', $request->email)->where('token', $request->pin)->delete();
                return response(['status' => 1, 'message' => "You can now reset your password" ], 200);
            }
            return response(['status' => 0, 'message' => "Unable to Verify it " ], 200);
        
        }
    }

    // If the above button response is 1, we will call the following api with an email and new password with confirmation
    public function resetPassword(Request $request)
    {        
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|max:255|exists:users,email',
            'password' => 'required|string|confirmed'
        ]);

        if ($validator->fails()) {
            return response(['status' => 0, 'message' => $validator->errors()->first()], 200);
        }
        $user = User::where('email',$request->email);
        $user->update(['password'=>Hash::make($request->password)]);

        // $token = $user->createToken('Laravel Password Grant Client')->accessToken;
        return response(['status' => 1, 'message' => "Your password has been reset" ], 200);
    }



}


