<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


Route::group(['middleware' => ['cors', 'json.response']], function () {

    // public routes
    Route::get('/checkCoachUsername', 'APIController@checkCoachUsername')->name('checkCoachUsername.api');
    
    Route::post('/registerCoach', 'APIController@registerCoach')->name('registerCoach.api');    
    Route::post('/registerAdmin', 'APIController@registerAdmin')->name('registerAdmin.api');    

    Route::get('/verifyCoachEmail', 'APIController@verifyCoachEmail')->name('verifyCoachEmail.api');
    Route::post('/verifyVerificationCodeforEmail', 'APIController@verifyVerificationCodeforEmail')->name('verifyVerificationCodeforEmail.api');
    
    Route::get('/verifyCoachForgetPassword', 'APIController@verifyCoachForgetPassword')->name('verifyCoachForgetPassword.api');
    Route::post('/verifyVerificationCodeforForgetPassword', 'APIController@verifyVerificationCodeforForgetPassword')->name('verifyVerificationCodeforForgetPassword.api');
    
    Route::post('/coachSignIn', 'APIController@coachSignIn')->name('coachSignIn.api');

    Route::post('/createCoachPassword', 'APIController@createCoachPassword')->name('createCoachPassword.api');

    Route::post('/updateStripeID', 'APIController@updateStripeID')->name('updateStripeID.api');

    // Route::post('/handleWebhook', 'APIController@handleWebhook')->name('handleWebhook.api');

    Route::post('/handleWebhook', 'APIWebhookController@handleWebhook')->name('handleWebhook.api');

    Route::get('/getClientSecret', 'APIController@getClientSecret')->name('getClientSecret.api');

    Route::get('/CheckSubscriptionStatus', 'APIController@CheckSubscriptionStatus')->name('CheckSubscriptionStatus.api');

    Route::get('/getCoachSubscriptions', 'APIController@getCoachSubscriptions')->name('getCoachSubscriptions.api');
    
    Route::get('/getClients', 'APIController@getClients')->name('getClients.api');

    Route::get('/getCheckinDetails', 'APIController@getCheckinDetails')->name('getCheckinDetails.api');

    Route::put('/assignMacro', 'APIController@assignMacro')->name('assignMacro.api');
    Route::get('/getMacros', 'APIController@getMacros')->name('getMacros.api');
    Route::delete('/deleteMacro', 'APIController@deleteMacro')->name('deleteMacro.api');
    Route::delete('/deleteExercise', 'APIController@deleteExercise')->name('deleteExercise.api');
    Route::delete('/deleteDay', 'APIController@deleteDay')->name('deleteDay.api');
    Route::get('/getWorkout', 'APIController@getWorkout')->name('getWorkout.api');
    Route::put('/assignWorkout', 'APIController@assignWorkout')->name('assignWorkout.api');

    Route::get('/getClientDetails', 'APIController@getClientDetails')->name('getClientDetails.api');
    Route::get('/getCheckInPictures', 'APIController@getCheckInPictures')->name('getCheckInPictures.api');
    Route::post('/addFeedback', 'APIController@addFeedback')->name('addFeedback.api');




    // Diet and Meal APIs
    Route::put('/assignDietPlan', 'APIController@assignDietPlan')->name('assignDietPlan.api');
    Route::get('/getDietPlan', 'APIController@getDietPlan')->name('getDietPlan.api');
    Route::delete('/deleteMeal', 'APIController@deleteMeal')->name('deleteMeal.api');
    Route::delete('/deleteMealItem', 'APIController@deleteMealItem')->name('deleteMealItem.api');
    Route::delete('/deleteDietDay', 'APIController@deleteDietDay')->name('deleteDietDay.api');

    // Client Preferences APIs
    Route::post('/addClientPreference', 'APIController@addClientPreference')->name('addClientPreference.api');
    Route::get('/getClientPreferencesForCoach', 'APIController@getClientPreferencesForCoach')->name('getClientPreferencesForCoach.api');
    Route::get('/getClientPreferencesForClient', 'APIController@getClientPreferencesForClient')->name('getClientPreferencesForClient.api');
    Route::post('/updateClientPreferencesForCoach', 'APIController@updateClientPreferencesForCoach')->name('updateClientPreferencesForCoach.api');
    Route::post('/updateClientPreferencesForClient', 'APIController@updateClientPreferencesForClient')->name('updateClientPreferencesForClient.api');

    // Client Details API
    Route::get('/getClientDetailsById', 'APIController@getClientDetailsById')->name('getClientDetailsById.api');
    Route::get('/getClientDetailsByIdForAdmin', 'APIController@getClientDetailsByIdForAdmin')->name('getClientDetailsByIdForAdmin.api');



    Route::get('/searchFood', 'APIController@searchFood')->name('searchFood.api');

    Route::get('/getAllCoaches', 'APIController@getAllCoaches')->name('getAllCoaches.api');
    Route::get('/getAllClients', 'APIController@getAllClients')->name('getAllClients.api');

    Route::post('/addFAQ', 'APIController@addFAQ')->name('addFAQ.api');
    Route::delete('/deleteFAQ', 'APIController@deleteFAQ')->name('deleteFAQ.api');
    Route::get('/getAllFAQ', 'APIController@getAllFAQ')->name('getAllFAQ.api');


    Route::get('/getAllComplaints', 'APIController@getAllComplaints')->name('getAllComplaints.api');
    Route::put('/replyComplaint', 'APIController@replyComplaint')->name('replyComplaint.api');

    Route::get('/getCoachDetailsWithClients', 'APIController@getCoachDetailsWithClients')->name('getCoachDetailsWithClients.api');

    Route::post('/registerSocialCoach', 'APIController@registerSocialCoach')->name('registerSocialCoach.api');    
    Route::post('/socialCoachSignIn', 'APIController@socialCoachSignIn')->name('socialCoachSignIn.api');















    // Client API:
    Route::get('/checkClientUsername', 'ClientAPIController@checkClientUsername')->name('checkClientUsername.api');

    Route::get('/verifyClientEmail', 'ClientAPIController@verifyClientEmail')->name('verifyClientEmail.api');
    Route::post('/verifyVerificationCodeforClientEmail', 'ClientAPIController@verifyVerificationCodeforClientEmail')->name('verifyVerificationCodeforClientEmail.api');

    Route::get('/verifyClientForgetPassword', 'ClientAPIController@verifyClientForgetPassword')->name('verifyClientForgetPassword.api');
    Route::post('/verifyVerificationCodeforClientForgetPassword', 'ClientAPIController@verifyVerificationCodeforClientForgetPassword')->name('verifyVerificationCodeforClientForgetPassword.api');
    
    Route::post('/updateClientPassword', 'ClientAPIController@updateClientPassword')->name('updateClientPassword.api');

    Route::get('/searchByUsername', 'ClientAPIController@searchByUsername')->name('searchByUsername.api');


    Route::post('/registerClient', 'ClientAPIController@registerClient')->name('registerClient.api');    
    Route::post('/clientSignIn', 'ClientAPIController@clientSignIn')->name('clientSignIn.api');

    Route::post('/updateFcmToken', 'ClientAPIController@updateFcmToken')->name('updateFcmToken.api');

    Route::post('/registerSocialClient', 'ClientAPIController@registerSocialClient')->name('registerSocialClient.api');    
    Route::post('/socialClientSignIn', 'ClientAPIController@socialClientSignIn')->name('socialClientSignIn.api');



    Route::post('/favoriteCoach', 'ClientAPIController@favoriteCoach')->name('favoriteCoach.api');
    Route::get('/fetchFavoriteCoaches', 'ClientAPIController@fetchFavoriteCoaches')->name('fetchFavoriteCoaches.api');
    Route::delete('/removeFavoriteCoach', 'ClientAPIController@removeFavoriteCoach')->name('removeFavoriteCoach.api');

    Route::get('/fetchRecentCoaches', 'ClientAPIController@fetchRecentCoaches')->name('fetchRecentCoaches.api');

    Route::post('/addCoachPreference', 'ClientAPIController@addCoachPreference')->name('addCoachPreference.api');

    Route::post('/updateClientProfile', 'ClientAPIController@updateClientProfile')->name('updateClientProfile.api');

    Route::get('/fetchAllAssignedPlans', 'ClientAPIController@fetchAllAssignedPlans')->name('fetchAllAssignedPlans.api');

    Route::get('/getAllCoachesClient', 'ClientAPIController@getAllCoachesClient')->name('getAllCoachesClient.api');


    Route::get('/getAllCoachesWithoutFilter', 'ClientAPIController@getAllCoachesWithoutFilter')->name('getAllCoachesWithoutFilter.api');
    Route::get('/getWeeklyProgress', 'ClientAPIController@getWeeklyProgress')->name('getWeeklyProgress.api');

    Route::post('/addWeeklyProgress', 'ClientAPIController@addWeeklyProgress')->name('addWeeklyProgress.api');

    Route::get('/clientHome', 'ClientAPIController@clientHome')->name('clientHome.api');
    Route::get('/searchCoaches', 'ClientAPIController@searchCoaches')->name('searchCoaches.api');

    Route::post('/cancelCoachPreference', 'ClientAPIController@cancelCoachPreference')->name('cancelCoachPreference.api');




    Route::get('/visit-counter', 'Auth\ApiAuthController@incrementAndGetCount')->name('incrementAndGetCount.api');

});



    // protected routes
Route::middleware('token.valid')->group(function () {
    Route::post('/updateCoachPassword', 'APIController@updateCoachPassword')->name('updateCoachPassword.api');

    Route::get('/fetchCoachDetails', 'APIController@fetchCoachDetails')->name('fetchCoachDetails.api');
    Route::post('/updateCoach', 'APIController@updateCoach')->name('updateCoach.api');
    Route::get('/fetchClientDetails', 'APIController@fetchClientDetails')->name('fetchClientDetails.api');

});





// If we want to use apply API authentication
Route::middleware('auth:api')->group(function () {
    // Needs to be in the protected route below

});


//After Hosting on server, the laravel file manager might not link the app/public folder to the storage folder, even though it works fine locally
// So the following command will help us to link this two folder after deploying on server,
// The following command is kind of "php artisan storage:link" command on server, so instead of running this command on ssh terminal of our project directory,
// We can just write this command in the route and just go to our website's home url and add /linkstorage, that's it... it will link our storage folder..
Route::get('/linkstorage', function() {
    Artisan::call('storage:link');
    return "Storage link has been created!";
});
Route::get('/merge-folder/{folder}', function ($folder) {
    $folderPath = base_path($folder);
    if (File::exists($folderPath)) {
        File::deleteDirectory($folderPath);
        return "The $folder folder has been merged.";
    } else {
        return "The $folder folder does not exist.";
    }
});
Route::get('/clear', function() {
Artisan::call('cache:clear');
Artisan::call('config:cache');
Artisan::call('view:clear');
Artisan::call('config:clear');

return "All cleared successfully!";
});