<?php

use Illuminate\Database\Seeder;
use Faker\Factory as Faker;
use App\Models\User;
use App\Models\Coach;
use App\Models\Clients;
use App\Models\CheckInDetails;
use App\Models\CheckInPictures;
use App\Models\faq;
use App\Models\Complaints;


use Illuminate\Support\Facades\DB;



class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // // $this->call(CoachTableSeeder::class);
        // // $this->call(ClientTableSeeder::class);
        // $this->call(CheckInDetailsTableSeeder::class);
        // $this->call(CheckInPicturesTableSeeder::class);
        // $this->call(NotificationTypesSeeder::class);
        $this->call(FAQSeeder::class);
        $this->call(ComplaintSeeder::class);

    }
}




// Coach(coach_id, username, full_name, phone, email, password, bio, intro, profile_picture)
class CoachTableSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();
        foreach(range(1,10) as $index){
            Coach::create([
                'username' => $faker->name,
                'full_name' => $faker->name,
                'phone' => $faker->phoneNumber,
                'email' => $faker->email,
                'password'=>Hash::make('1111'),
                'bio' => $faker->sentence,
                'intro' => '/storage/videos/video.mp4',
                'profile_picture' => '/storage/images/photo.jpg',
                'stripe_id' => $faker->bothify('************'),
                'city' => $faker->city,
                'postal_code' => $faker->postcode,
                'country'=> $faker->country,
                // 'user_role' => 'coach',
                // 'is_email_varified' => false,
            ]);
        }
    }
}
// // Clients(client_id, coach_id, full_name, email, password)
// class ClientTableSeeder extends Seeder
// {
//     /**
//      * Seed the application's database.
//      *
//      * @return void
//      */
//     public function run()
//     {
//         $faker = Faker::create();
//         foreach(range(1,5) as $index){
//             Clients::create([
//                 'coach_id' => $faker->unique()->randomElement(Coach::pluck('coach_id')),
//                 'full_name' => $faker->name,
//                 'email' => $faker->email,
//                 'password'=>Hash::make('1111'),
//             ]);
//         }
//     }
// }




class ClientTableSeeder extends Seeder
{
    /**
     * Seed the application's database with clients for coach_id = 13.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();

        foreach(range(1, 5) as $index){
            Clients::create([
                'coach_id' => 13,
                'full_name' => $faker->name,
                'email' => $faker->unique()->safeEmail,
                'password' => Hash::make('1111'),
                'username' => $faker->unique()->userName,
                'profile_picture' => $faker->imageUrl(),
                'gender' => $faker->randomElement(['male', 'female']),
                'age' => $faker->numberBetween(18, 60),
                'weight' => $faker->numberBetween(50, 100),
                'height' => $faker->numberBetween(150, 200),
            ]);
        }
    }
}



class CheckInDetailsTableSeeder extends Seeder
{
    /**
     * Seed the application's database with check-in details for clients of coach_id = 13.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();

        $clients = Clients::where('coach_id', 13)->get();

        foreach ($clients as $client) {
            foreach (range(1, 3) as $index) {
                CheckInDetails::create([
                    'client_id' => $client->client_id,
                    'coach_id' => 13,
                    'checkin_date' => $faker->date(),
                    'checkin_day' => $faker->dayOfWeek,
                    'checkin_week' => $faker->numberBetween(1, 52),
                    'checkin_month' => $faker->monthName,
                    'checkin_year' => $faker->year,
                    'checkin_time' => $faker->time(),
                    'chest' => $faker->numberBetween(30, 50),
                    'shoulders' => $faker->numberBetween(40, 60),
                    'waist' => $faker->numberBetween(30, 50),
                    'hips' => $faker->numberBetween(30, 50),
                    'thighs' => $faker->numberBetween(20, 30),
                    'arms' => $faker->numberBetween(10, 20),
                    'how_was_your_week' => $faker->paragraph,
                    'any_stress_depression' => $faker->paragraph,
                    'how_was_macros' => $faker->paragraph,
                    'how_many_missed_meals' => $faker->numberBetween(0, 3),
                    'how_many_cheat_meals' => $faker->numberBetween(0, 3),
                    'how_was_sleep' => $faker->paragraph,
                    'how_is_appetite_and_digestion' => $faker->paragraph,
                    'how_is_recovery' => $faker->paragraph,
                    'training_strength' => $faker->paragraph,
                    'coach_feedback' => $faker->paragraph,
                ]);
            }
        }
    }
}



class CheckInPicturesTableSeeder extends Seeder
{
    /**
     * Seed the application's database with pictures for check-in details.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();

        $checkInDetails = CheckInDetails::where('coach_id', 13)->get();

        foreach ($checkInDetails as $detail) {
            foreach (range(1, 4) as $index) {
                CheckInPictures::create([
                    'check_in_details_id' => $detail->details_id,
                    'picture' => $faker->imageUrl(),
                ]);
            }
        }
    }
}




class NotificationTypesSeeder extends Seeder
{
    public function run()
    {
        DB::table('notification_types')->insert([
            ['name' => 'Macro Plan Assigned', 'description' => 'You have been assigned a Macro Plan, Check it out!'],
            ['name' => 'Macro Plan Updated', 'description' => 'You have an update regarding your Macro Plan, Check it out!'],
            ['name' => 'Workout Plan Assigned', 'description' => 'You have been assigned a Workout Plan, Check it out!'],
            ['name' => 'Workout Plan Update', 'description' => 'You have an update regarding your Workout Plan, Check it out!'],
            ['name' => 'Diet Plan Assigned', 'description' => 'You have been assigned a Diet Plan, Check it out!'],
            ['name' => 'Diet Plan Update', 'description' => 'You have an update regarding your Diet Plan, Check it out!'],
            ['name' => 'Coach Accepted Your Request', 'description' => 'One of your preferred coaches has accepted your request!'],
            ['name' => 'Coach Rejected Your Request', 'description' => 'One of your preferred coaches has rejected your request!'],
            ['name' => 'Client Update', 'description' => 'One of your clients has updated its details, Check it out!'],
            ['name' => 'Progress Update', 'description' => 'One of your clients has updated its progress images and details, Check it out and give your client feedback.']
        ]);
    }

}




class FAQSeeder extends Seeder
{
    /**
     * Seed the FAQs table.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();

        foreach (range(1, 10) as $index) {
            faq::create([
                'question' => $faker->sentence,
                'answer' => $faker->paragraph,
            ]);
        }
    }
}


class ComplaintSeeder extends Seeder
{
    /**
     * Seed the Complaints table.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();

        $clients = Clients::all(); // Fetch all clients

        foreach ($clients as $client) {
            foreach (range(1, 5) as $index) { // Each client gets 5 complaints
                Complaints::create([
                    'client_id' => $client->client_id,
                    'complaint' => $faker->sentence,
                    'reply' => $faker->optional()->sentence, // Randomly add a reply
                ]);
            }
        }
    }
}

