<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsTable extends Migration
{
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->bigIncrements('notification_id');
            $table->unsignedBigInteger('recipient_user_id'); // Client ID
            $table->unsignedBigInteger('sender_user_id')->nullable(); // Coach ID or null
            $table->unsignedBigInteger('notification_type_id'); // Foreign key from notification_types
            $table->enum('related_entity_type', ['diet', 'workout', 'macro', 'preference', 'progress']); 
            $table->unsignedBigInteger('related_entity_id'); // e.g., diet_plan_id, workout_id, etc.
            $table->boolean('is_read')->default(false); // 0 for unread, 1 for read


            // Foreign keys
            $table->foreign('recipient_user_id')->references('client_id')->on('clients');
            $table->foreign('sender_user_id')->references('coach_id')->on('coaches');
            $table->foreign('notification_type_id')->references('notification_type_id')->on('notification_types');

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }

    public function down()
    {
        Schema::dropIfExists('notifications');
    }
}
