<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDietPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('diet_plans', function (Blueprint $table) {
            $table->id('diet_plan_id');
            $table->unsignedBigInteger('coach_id');
            $table->unsignedBigInteger('assigned_to'); // assuming assigned_to is a user/client id

            // Unique constraint on coach_id and assigned_to
            // $table->unique(['coach_id', 'assigned_to']);


            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));

            // Foreign key constraints (assuming the coaches and clients/users tables exist)
            $table->foreign('coach_id')->references('coach_id')->on('coaches');
            $table->foreign('assigned_to')->references('client_id')->on('clients'); // Adjust if the client/user table is different
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('diet_plans');
    }
}
