<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRepsSetsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reps_sets', function (Blueprint $table) {
            $table->id('reps_set_id');
            $table->unsignedBigInteger('exercise_id');
            $table->string('set');
            $table->string('reps');

            // $table->unique(['exercise_id', 'set']);

            $table->foreign('exercise_id')->references('exercise_id')->on('exercises');

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reps_sets');
    }
}


