<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentMethodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->bigIncrements('payment_method_id');
            $table->string('stripe_payment_method_id')->unique();
            $table->string('customer')->nullable(); // Foreign key to coaches.stripe_id
            $table->foreign('customer')->references('stripe_id')->on('coaches');
            $table->unsignedBigInteger('coach_id')->nullable()->unique(); // Foreign key to coaches.coach_id
            $table->foreign('coach_id')->references('coach_id')->on('coaches');
            $table->string('type')->nullable(); // Adjust type based on your needs
            $table->string('card_brand')->nullable();
            $table->string('name_on_card')->nullable();
            $table->string('last_4_digits')->nullable();
            $table->integer('exp_month')->nullable();
            $table->integer('exp_year')->nullable();
            $table->string('country')->nullable();
            $table->string('postal_code')->nullable();
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_methods');
    }
}
