<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class clientPreferences extends Model
{
    protected $primaryKey = 'client_preferences_id';

    protected $fillable = [
        'client_id',
        'coach_id',
        'active',
        'coach_status',
        'client_status',
        'message'
    ];

    // Define any necessary relationships
    public function client()
    {
        return $this->belongsTo(Clients::class, 'client_id', 'client_id');
    }

    public function coach()
    {
        return $this->belongsTo(Coach::class, 'coach_id', 'coach_id');
    }
}
