<?php

// app/Models/VisitCounter.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VisitCounter extends Model
{
    protected $fillable = ['page_url', 'visit_count'];
    
    /**
     * Increment and get the visit count in one atomic operation
     */
    public static function incrementAndGetCount($pageUrl)
    {
        // This performs the operation atomically to prevent race conditions
        $counter = static::firstOrCreate(
            ['page_url' => $pageUrl],
            ['visit_count' => 100]
        );
        
        // Increment and get the updated value
        $counter->increment('visit_count');
        
        return $counter->visit_count;
    }
}