<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RecentCoaches extends Model
{
    protected $primaryKey = 'recent_coach_id';

    protected $fillable = [
        'client_id',
        'coach_id',
    ];

    // Relationships
    public function client()
    {
        return $this->belongsTo(Clients::class, 'client_id');
    }

    public function coach()
    {
        return $this->belongsTo(Coach::class, 'coach_id');
    }
}
