<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MealItems extends Model
{
    protected $primaryKey = 'meal_items_id';

    protected $fillable = [
        'meal_id',
        'item_title',
        'serving_size',
        'serving_unit',
        'fat',
        'carbohydrates',
        'protein',
        'fibre',
        'calories',
        'sugar',
        'sodium',
        'note'
    ];

    public function meal()
    {
        return $this->belongsTo(Meals::class, 'meal_id', 'meal_id');
    }


}