<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Coach extends Model
{
    //
    protected $primaryKey = 'coach_id';
    protected $fillable = ['username', 'full_name', 'phone', 'email', 'password', 'city', 'postal_code', 'country'];
    

    // Relationship for favorites
    public function favorites()
    {
        return $this->hasMany(FavoriteCoaches::class, 'coach_id', 'coach_id');
    }

    // Relationship for check-in details
    public function checkInDetails()
    {
        return $this->hasMany(checkInDetails::class, 'coach_id', 'coach_id');
    }

    // Relationship for recent interactions
    public function recentInteractions()
    {
        return $this->hasMany(RecentCoaches::class, 'coach_id', 'coach_id');
    }


   // Relationship for client preferences
    public function activeClientPreferences()
    {
        return $this->hasMany(clientPreferences::class, 'coach_id', 'coach_id')->where('active', true);
    }


}
