<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Clients extends Model
{
    //
    protected $primaryKey = 'client_id';
    protected $fillable = ['coach_id', 'full_name', 'email', 'username','profile_picture', 'is_email_verified', 'password', 'gender', 'age', 'level', 'weight', 'height', 'is_diet_assigned', 'is_macro_assigned', 'is_training_assigned'];
 

    // Define relationships
    public function checkInDetails()
    {
        return $this->hasMany(checkInDetails::class, 'client_id', 'client_id');
    }

    public function macroPlans()
    {
        return $this->hasMany(macroPlans::class, 'client_assigned_id', 'client_id');
    }

    public function workoutPlans()
    {
        return $this->hasMany(workoutPlans::class, 'client_assigned_id', 'client_id');
    }
}
