<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Session;

class EnsureTokenIsValid
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();
        if (!$token) {
            return response()->json(['message' => 'No token provided'], 401);
        }

        // Decrypt and validate token existence
        // $session = Session::where('authentication_token', decrypt($token))->first();
        $session = Session::where('authentication_token', $token)->first();

        if (!$session) {
            return response()->json(['message' => 'Invalid token or token does not match the user/coach'], 401);
        }

        return $next($request);
    }
}
