<?php

// app/Helpers/NotificationHelper.php

namespace App\Helpers;

use App\Models\Notifications;
use App\Models\NotificationType;

class NotificationHelper
{
    /**
     * Create a notification entry.
     *
     * @param int $recipientId
     * @param int $senderId
     * @param int $notificationTypeId
     * @param int|null $relatedEntityId
     * @return void
     */
    public static function createNotification($recipientId, $senderId, $notificationTypeId, $relatedEntityId = null)
    {
        Notifications::create([
            'recipient_user_id' => $recipientId,
            'sender_user_id' => $senderId,
            'notification_type_id' => $notificationTypeId,
            'related_entity_id' => $relatedEntityId,
            'is_read' => 0 // default to unread
        ]);
    }
}
